implementation module windowhandle


//	Clean Object I/O library, version 1.0.1


import	StdBool, StdList
import	StdMaybe, StdWindowDef
import	ospicture, oswindow
import	commondef, controldefaccess, keyfocus, receiverhandle, receivertable, systemid, windowaccess


::	ControlState ls ps											// The internal implementation of a control
	:==	WElementHandle ls ps									// is a WElementHandle

::	WindowHandles ps											// Windows currently are only dialogs
	=	{	whsWindows		:: [WindowStateHandle ps]			// The windows and their controls of a process
//		,	whsCursorInfo	:: CursorInfo						// The global cursor information
		,	whsIds			:: [Int]							// The list of free system ids for windows
		,	whsNrWindowBound:: Bound							// The maximum number of windows that are allowed to be opened
		,	whsModal		:: Bool								// Flag: the window system is modal (used in combination with modal dialogues)
		}
::	WindowStateHandle ps
	=	E..ls:
		{	wshIds			:: WIDS								// A window is identified by an Id and an OSWindowPtr
		,	wshHandle		:: Maybe (WindowLSHandle ls ps)		// If used as placeholder, Nothing; otherwise window with local state
		}
::	WIDS
	=	{	wId				:: Id								// Id  of window
		,	wPtr			:: !OSWindowPtr						// Ptr of window
		}
::	WindowLSHandle ls ps
	=	{	wlsState		:: ls								// The local state of this window
		,	wlsHandle		:: WindowHandle ls ps				// The window implementation
		}
::	WindowHandle ls ps
	=	{	whMode			:: WindowMode						// The window mode (Modal or Modeless)
		,	whKind			:: WindowKind						// The window kind (Window or Dialog)
		,	whTitle			:: Title							// The window title
		,	whItemNrs		:: [Int]							// The list of free system item numbers for all controls
		,	whKeyFocus		:: KeyFocus							// The item that has the keyboard input focus
		,	whWindowInfo	:: Maybe WindowInfo					// Additional information about the Window (Nothing for Dialogs)
		,	whItems			:: [WElementHandle ls ps]			// The window controls
		,	whShow			:: Bool								// The visibility of the window (True iff visible)
		,	whSelect		:: Bool								// The WindowSelectState==Able (by default True)
		,	whAtts			:: [WindowAttribute *(ls,ps)]		// The window attributes
		,	whDefaultId		:: Maybe Id							// The Id of the optional default button
		,	whCancelId		:: Maybe Id							// The Id of the optional cancel  button
		,	whSize			:: Size								// The exact size of the window
		}
::	WindowMode													// Modality of the window
	=	Modal													// Modal window (only for dialogs)
	|	Modeless												// Modeless window
::	WindowKind
	=	IsWindow												// Window kind
	|	IsDialog												// Dialog kind
::	LookInfo
	=	{	lookFun			:: Look								// The Look function
		,	lookPen			:: Pen								// The settings of the Pen
		}
::	WindowInfo
	=	{	windowDomain	:: ViewDomain						// The optional view domain of the window
		,	windowOrigin	:: Point							// The Origin of the view domain
		,	windowHScroll	:: Maybe ScrollInfo					// The scroll data of the WindowHScroll attribute
		,	windowVScroll	:: Maybe ScrollInfo					// The scroll data of the WindowVScroll attribute
		,	windowLook		:: LookInfo							// The look and pen of the window
		,	windowClip		:: ClipState						// The clipped elements of the window
		}
::	ScrollInfo
	=	{	scrollFunction	:: ScrollFunction					// The ScrollFunction of the (horizontal/vertical) scroll attribute
		,	scrollItemPos	:: Point							// The exact position of the scrollbar
		,	scrollItemSize	:: Size								// The exact size of the scrollbar
		,	scrollItemPtr	:: OSWindowPtr						// The OSWindowPtr of the scrollbar
		}
::	ClipState
	=	{	clipRgn			:: !OSRgnHandle						// The clipping region
		,	clipOk			:: !Bool							// Flag: the clipping region is valid
		}
::	WElementHandle	ls	ps
	=	WItemHandle			(WItemHandle		ls ps)
	|	WListLSHandle		[WElementHandle		ls ps]
	|	WExtendLSHandle		(WExtendLSHandle	ls ps)
	|	WChangeLSHandle		(WChangeLSHandle	ls ps)
::	WExtendLSHandle	ls ps
	=	E..ls1:
		{	wExtendLS		:: ls1
		,	wExtendItems	:: [WElementHandle *(ls1,ls) ps]
		}
::	WChangeLSHandle	ls ps
	=	E..ls1:
		{	wChangeLS		:: ls1
		,	wChangeItems	:: [WElementHandle ls1 ps]
		}
::	WItemHandle		ls ps
	=	{	wItemId			:: Maybe Id							// If the control has a (ControlId id) attribute, then Just id; Nothing
		,	wItemNr			:: Int								// The internal nr of this control  (generated from whItemNrs)
		,	wItemKind		:: ControlKind						// The sort of control
		,	wItemShow		:: Bool								// The visibility of the control (True iff visible)
		,	wItemSelect		:: Bool								// The ControlSelectState==Able  (by default True)
		,	wItemInfo		:: WItemInfo ls ps					// Additional information of the control
		,	wItemAtts		:: [ControlAttribute *(ls,ps)]		// The control attributes
		,	wItems			:: [WElementHandle ls ps]			// In case of	CompoundControl	: its control elements
																//				Otherwise		: []
		,	wItemPos		:: Point							// The exact position of the item
		,	wItemFixedPos	:: Bool								// The layout of the item is either Fix or relative to a Fix item
		,	wItemSize		:: Size								// The exact size of the item
		,	wItemPtr		:: OSWindowPtr						// The ptr to the item (OSNoWindowPtr if no handle)
		}
::	WItemInfo		ls ps
	=	RadioInfo			(RadioInfo	  *(ls,ps))				// In case of	RadioControl	: the radio items information
	|	CheckInfo			(CheckInfo	  *(ls,ps))				// In case of	CheckControl	: the check items information
	|	PopUpInfo			(PopUpInfo	  *(ls,ps))				// In case of	PopUpControl	: the pop up information
	|	SliderInfo			(SliderInfo	  *(ls,ps))				// In case of	SliderControl	: the slider information
	|	TextInfo			TextInfo							// In case of	TextControl		: the text information
	|	EditInfo			EditInfo							// In case of	EditControl		: the edit text information
	|	ButtonInfo			ButtonInfo							// In case of	ButtonControl	: the button information
	|	CustomButtonInfo	CustomButtonInfo					// In case of	CustomButtonControl	: the custom button information
	|	CustomInfo			CustomInfo							// In case of	CustomControl		: the custom information
	|	CompoundInfo		CompoundInfo						// In case of	CompoundControl	: the compound control information
	|	ReceiverInfo		(ReceiverHandle	ls ps)				// In case of	ReceiverControl	: the receiver information
	|	NoWItemInfo												// No additional information
::	RadioInfo		ps
	=	{	radioItems		:: [RadioItemInfo ps]				// The radio items and their exact position (initially zero)
		,	radioLayout		:: RowsOrColumns					// The layout of the radio items
		,	radioIndex		:: Int								// The currently selected radio item (1<=radioIndex<=length radioItems)
		}
::	RadioItemInfo	ps
	=	{	radioItem		:: RadioControlItem ps				// The RadioItem of the definition
		,	radioItemPos	:: !Point							// The exact position of the item
		,	radioItemSize	:: Size								// The exact size of the item
		,	radioItemPtr	:: OSWindowPtr						// The OSWindowPtr of the item
		}
::	CheckInfo		ps
	=	{	checkItems		:: [CheckItemInfo ps]				// The check items and their exact position (initially zero)
		,	checkLayout		:: RowsOrColumns					// The layout of the check items
		}
::	CheckItemInfo	ps
	=	{	checkItem		:: CheckControlItem ps				// The CheckItem of the definition
		,	checkItemPos	:: !Point							// The exact position of the item
		,	checkItemSize	:: Size								// The exact size of the item
		,	checkItemPtr	:: OSWindowPtr						// The OSWindowPtr of the item
		}
::	PopUpInfo		ps
	=	{	popUpInfoItems	:: [PopUpControlItem ps]			// The pop up items
		,	popUpInfoIndex	:: Index							// The currently selected pop up item (1<=popUpInfoIndex<=length popUpInfoItems)
		}
::	SliderInfo		ps
	=	{	sliderInfoDir	:: Direction						// The direction of the slider
		,	sliderInfoLength:: Length							// The length (in pixels) of the slider
		,	sliderInfoState	:: SliderState						// The current slider state
		,	sliderInfoAction:: SliderAction ps					// The action of the slider
		}
::	TextInfo
	=	{	textInfoText	:: TextLine							// The content of the text control
		}
::	EditInfo
	=	{	editInfoText	:: !TextLine						// The content of the edit control
		,	editInfoWidth	:: Width							// The width (in pixels) of the edit item
		,	editInfoNrLines	:: NrLines							// The nr of complete visible lines of the edit item
		}
::	ButtonInfo
	=	{	buttonInfoText	:: TextLine							// The title of the button control
		}
::	CustomButtonInfo
	=	{	cButtonInfoLook	:: LookInfo							// The look of the custom button control
		}
::	CustomInfo
	=	{	customInfoLook	:: LookInfo							// The look of the custom control
		}
::	CompoundInfo
	=	{	compoundDomain	:: ViewDomain						// The optional view domain of the compound control
		,	compoundOrigin	:: Point							// The Origin of the view domain
		,	compoundHScroll	:: Maybe ScrollInfo					// The scroll data of the ControlHScroll attribute
		,	compoundVScroll	:: Maybe ScrollInfo					// The scroll data of the ControlVScroll attribute
		,	compoundLookInfo:: Maybe CompoundLookInfo			// The look information of the compound control
		}
::	CompoundLookInfo
	=	{	compoundLook	:: LookInfo							// The look of the compound control
		,	compoundClip	:: ClipState						// The clipped elements of the compound control
		}
::	ControlKind
	=	IsRadioControl
	|	IsCheckControl
	|	IsPopUpControl
	|	IsSliderControl
	|	IsTextControl
	|	IsEditControl
	|	IsButtonControl
	|	IsCustomButtonControl
	|	IsCustomControl
	|	IsCompoundControl
	|	IsOtherControl ControlType								// Of other controls the ControlType


//	Equalities on simple types:

instance == WIDS where
	(==) :: !WIDS !WIDS -> Bool
	(==) wids wids` = wids.wPtr==wids`.wPtr && wids.wId==wids`.wId
instance == WindowMode where
	(==) :: !WindowMode !WindowMode -> Bool
	(==) Modal		mode = case mode of
								Modal		-> True
								_			-> False
	(==) Modeless	mode = case mode of
								Modeless	-> True
								_			-> False

instance == WindowKind where
	(==) :: !WindowKind !WindowKind -> Bool
	(==) IsWindow	kind = case kind of
								IsWindow	-> True
								_			-> False
	(==) IsDialog	kind = case kind of
								IsDialog	-> True
								_			-> False

instance == ControlKind where
	(==) :: !ControlKind !ControlKind -> Bool
	(==) IsRadioControl			kind = case kind of
											IsRadioControl			-> True
											_						-> False
	(==) IsCheckControl			kind = case kind of
											IsCheckControl			-> True
											_						-> False
	(==) IsPopUpControl			kind = case kind of
											IsPopUpControl			-> True
											_						-> False
	(==) IsSliderControl		kind = case kind of
											IsSliderControl			-> True
											_						-> False
	(==) IsTextControl			kind = case kind of
											IsTextControl			-> True
											_						-> False
	(==) IsEditControl			kind = case kind of
											IsEditControl			-> True
											_						-> False
	(==) IsButtonControl		kind = case kind of
											IsButtonControl			-> True
											_						-> False
	(==) IsCustomButtonControl	kind = case kind of
											IsCustomButtonControl	-> True
											_						-> False
	(==) IsCustomControl		kind = case kind of
											IsCustomControl			-> True
											_						-> False
	(==) IsCompoundControl		kind = case kind of
											IsCompoundControl		-> True
											_						-> False
	(==) (IsOtherControl type1)	kind = case kind of
											IsOtherControl type2	-> type1==type2
											_						-> False
instance toString ControlKind where
	toString :: !ControlKind -> {#Char}
	toString IsRadioControl				= "IsRadioControl"
	toString IsCheckControl				= "IsCheckControl"
	toString IsPopUpControl				= "IsPopUpControl"
	toString IsSliderControl			= "IsSliderControl"
	toString IsTextControl				= "IsTextControl"
	toString IsEditControl				= "IsEditControl"
	toString IsButtonControl			= "IsButtonControl"
	toString IsCustomButtonControl		= "IsCustomButtonControl"
	toString IsCustomControl			= "IsCustomControl"
	toString IsCompoundControl			= "IsCompoundControl"
	toString (IsOtherControl type)		= "(IsOtherControl "+++type+++")"

/*	The given ControlKind corresponds with a custom-drawn control.
*/
isCustomisedControl :: !ControlKind -> Bool
isCustomisedControl IsCustomButtonControl	= True
isCustomisedControl IsCustomControl			= True
isCustomisedControl _						= False

/*	The given ControlKind corresponds with a control that contains other controls (CompoundControl).
*/
isRecursiveControl :: !ControlKind -> Bool
isRecursiveControl IsCompoundControl	= True
isRecursiveControl _					= False


//	Conversion functions from ControlState to WElementHandle, and vice versa:

WElementHandleToControlState :: !(WElementHandle .ls .ps) -> ControlState .ls .ps
WElementHandleToControlState wH = wH

ControlStateToWElementHandle :: !(ControlState .ls .ps) -> WElementHandle .ls .ps
ControlStateToWElementHandle wH = wH


/*	Bind all receiverids until a duplicate is found:
	if one is found, return False; otherwise return True.
*/
bindReceiverControlIds :: !SystemId !Id ![WElementHandle .ls .ps] !ReceiverTable
							  -> (!Bool,![WElementHandle .ls .ps],!ReceiverTable)
bindReceiverControlIds ioId wId [itemH:itemHs] rt
	# (ok,itemH,rt)	= bindReceiverControlIds` ioId wId itemH rt
	| not ok
	= (ok,[itemH:itemHs],rt)
	# (ok,itemHs,rt)= bindReceiverControlIds ioId wId itemHs rt
	= (ok,[itemH:itemHs],rt)
where
	bindReceiverControlIds` :: !SystemId !Id !(WElementHandle .ls .ps) !ReceiverTable
									-> (!Bool,!WElementHandle .ls .ps, !ReceiverTable)
	bindReceiverControlIds` ioId wId (WListLSHandle itemHs) rt
		# (ok,itemHs,rt)	= bindReceiverControlIds ioId wId itemHs rt
		= (ok,WListLSHandle itemHs,rt)
	bindReceiverControlIds` ioId wId (WExtendLSHandle wExH=:{wExtendItems}) rt
		# (ok,itemHs,rt)	= bindReceiverControlIds ioId wId wExtendItems rt
		= (ok,WExtendLSHandle {wExH & wExtendItems=itemHs},rt)
	bindReceiverControlIds` ioId wId (WChangeLSHandle wChH=:{wChangeItems}) rt
		# (ok,itemHs,rt)	= bindReceiverControlIds ioId wId wChangeItems rt
		= (ok,WChangeLSHandle {wChH & wChangeItems=itemHs},rt)
	bindReceiverControlIds` ioId wId (WItemHandle itemH=:{wItemKind,wItemInfo}) rt
		| not (isReceiverControl wItemKind)
		= (ok,WItemHandle itemH1,rt1)
		with
			(ok,itemHs,rt1)	= bindReceiverControlIds ioId wId itemH.wItems rt
			itemH1			= {itemH & wItems=itemHs}
		# maybe_rte		= getReceiverTableEntry id rt
		| isJust maybe_rte
		= (False,WItemHandle itemH,rt)
		# recLoc		= {rlIOId=ioId,rlDevice=WindowDevice,rlParentId=wId,rlReceiverId=id}
		# rte			= {rteLoc=recLoc,rteSelectState=if itemH.wItemSelect Able Unable,rteASMCount=0}
		# (_,rt)		= addReceiverToReceiverTable rte rt
		= (True, WItemHandle itemH,rt)
	where
		rH				= getWItemReceiverInfo wItemInfo
		id				= rH.rId
		
		isReceiverControl (IsOtherControl type)
			= type=="Receiver" || type=="Receiver2"
		isReceiverControl _
			= False
bindReceiverControlIds _ _ itemHs rt
	= (True,itemHs,rt)


/*	Determine the list of window items that can obtain the keyboard input focus.
*/
getWElementKeyFocusIds :: !Bool ![WElementHandle .ls .ps] -> (![FocusItem],![WElementHandle .ls .ps])
getWElementKeyFocusIds shownContext [itemH:itemHs]
	# (ids1,itemH)	= getWElementKeyFocusIds` shownContext itemH
	  (ids2,itemHs)	= getWElementKeyFocusIds  shownContext itemHs
	= (ids1++ids2,[itemH:itemHs])
where
	getWElementKeyFocusIds` :: !Bool !(WElementHandle .ls .ps) -> (![FocusItem],!WElementHandle .ls .ps)
	getWElementKeyFocusIds` shownContext (WListLSHandle itemHs)
		# (ids,itemHs)	= getWElementKeyFocusIds shownContext itemHs
		= (ids,WListLSHandle itemHs)
	getWElementKeyFocusIds` shownContext (WExtendLSHandle wExH=:{wExtendItems=itemHs})
		# (ids,itemHs)	= getWElementKeyFocusIds shownContext itemHs
		= (ids,WExtendLSHandle {wExH & wExtendItems=itemHs})
	getWElementKeyFocusIds` shownContext (WChangeLSHandle wChH=:{wChangeItems=itemHs})
		# (ids,itemHs)	= getWElementKeyFocusIds shownContext itemHs
		= (ids,WChangeLSHandle {wChH & wChangeItems=itemHs})
	getWElementKeyFocusIds` shownContext (WItemHandle itemH)
		# (ids,itemH)	= getWItemKeyFocusIds itemH
		= (ids,WItemHandle itemH)
	where
		getWItemKeyFocusIds :: !(WItemHandle .ls .ps) -> (![FocusItem],!WItemHandle .ls .ps)
		getWItemKeyFocusIds itemH=:{wItemNr,wItemKind,wItemShow,wItemAtts,wItems}
			| wItemKind==IsEditControl
			= (focus,itemH)
			| keySensitive && hasKeyAtt
			= (focus,itemH)
			# (focus,itemHs)= getWElementKeyFocusIds (shownContext && wItemShow) wItems
			  itemH			= {itemH & wItems=itemHs}
			= (focus,itemH)
		where
			focus			= [{focusNr=wItemNr,focusShow=shownContext}]
			hasKeyAtt		= Contains iscontrolkeyboard wItemAtts
			keySensitive	= wItemKind==IsCustomControl
getWElementKeyFocusIds _ _
	= ([],[])


/*	Generate internal numbers for all WElementHandles which wItemNr==0.
*/
genWElementItemNrs :: ![Int] ![WElementHandle .ls .ps] -> (![Int],![WElementHandle .ls .ps])
genWElementItemNrs nrs [itemH:itemHs]
	# (nrs,itemH)	= genWElementNrs  nrs itemH
	  (nrs,itemHs)	= genWElementItemNrs nrs itemHs
	= (nrs,[itemH:itemHs])
where
	genWElementNrs :: ![Int] !(WElementHandle .ls .ps) -> (![Int],!WElementHandle .ls .ps)
	genWElementNrs nrs (WListLSHandle itemHs)
		# (nrs,itemHs)	= genWElementItemNrs nrs itemHs
		= (nrs,WListLSHandle itemHs)
	genWElementNrs nrs (WExtendLSHandle wExH=:{wExtendItems=itemHs})
		# (nrs,itemHs)	= genWElementItemNrs nrs itemHs
		= (nrs,WExtendLSHandle {wExH & wExtendItems=itemHs})
	genWElementNrs nrs (WChangeLSHandle wChH=:{wChangeItems=itemHs})
		# (nrs,itemHs)	= genWElementItemNrs nrs itemHs
		= (nrs,WChangeLSHandle {wChH & wChangeItems=itemHs})
	genWElementNrs nrs wItemH=:(WItemHandle itemH=:{wItemNr,wItemKind,wItems})
		# (nrs,itemHs)	= genWElementItemNrs nrs wItems
		| wItemNr<>0
		= (nrs,WItemHandle {itemH & wItems=itemHs})
		# (nr,nrs)		= HdTl nrs
		= (nrs,WItemHandle {itemH & wItemNr=nr,wItems=itemHs})
genWElementItemNrs nrs _
	= (nrs,[])
